﻿/*		VERSION:  1
	
SETTINGS:
	(code)			Array of keyboard-codes
	(done)			Function called when the code is successfully entered
	(rightKey)	Function called each time that the right key in the code is pressed
	(wrongKey)	Function called each time that the code is mis-typed
	(tooSlow)		Function called when the code is typed too slowly
	(seconds)		Seconds allowed between key-presses
	
	All settings are optional and can be set or modified afterwards
	
	
USAGE:
	#include "secretCode.as"
	
	konami = secretCode();
	konami.code = [
		Key.UP,
		Key.UP,
		Key.DOWN,
		Key.DOWN,
		Key.LEFT,
		Key.RIGHT,
		Key.LEFT,
		Key.RIGHT,
		66,	// B
		65	// A
	];// code
	konami.done = function(){
		trace("full code entered");
	}// done()
	konami.rightKey = function(){
		trace( "Right: "+String.fromCharCode(Key.getCode())+" ("+Key.getCode()+")" );
	}// rightKey()
	konami.wrongKey = function(){
		trace("NOPE");
	}// wrongKey()
	konami.seconds = 0.3;
	konami.tooSlow = function(){
		trace("you're too slow");
	}// tooSlow()
	konami.enable();
	
	onUnload = function(){
		konami.disable();
	}// onUnload()
*/
secretCode = function( input )
{
	var code = input.code || [];
	var done = input.done || function(){};
	var wrongKey = input.wrongKey || function(){};
	var tooSlow = input.tooSlow || function(){};
	
	var output = {
		code:code,
		done:done,						// done()				// full code entered correctly
		rightKey:rightKey,		// righKey()		// keypress is correct
		wrongKey:wrongKey,		// wrongKey()		// code mis-typed
		tooSlow:tooSlow,			// timeError()	// didn't enter the code fast enough
		
		index:0,
		timeout:null,
		interval:null,
		onKeyDown:function()
		{
			if(this.interval)		clearTimeout(this.interval);		// stop checking whether the code is being entered too slowly... for now
			var thisKey = Key.getCode();
			if(thisKey == this.code[this.index])
			{// if:  key matches code
				this.rightKey();
				this.index += 1;
				if(this.index==this.code.length)
				{// if:  full code entered
					this.reset();
					this.done();
				}// if:  full code entered
				else
				{// if:  code is still incomplete
					// impose a time-limit for the next key
					if(this.timeout != null)
					{// if:  this code has a time limit
						this.interval = setTimeout( this.outOfTime, this.timeout, this );
					}// if:  this code has a time limit
				}// if:  code is still incomplete
			}// if:  key matches code
			else
			{// if:  key does NOT fit the code
				this.wrongKey();
				this.reset();
			}// if:  key does NOT fit the code
		},// press()
		outOfTime:function( _this )
		{
			var _this = this || _this;
			_this.tooSlow();
			_this.reset();
		},
		reset:function()
		{
			this.index = 0;
		},// reset()
		enable:function()
		{
			Key.addListener(this);
		},// enable()
		disable:function()
		{
			Key.removeListener(this);
		},// disable()
		null:null
	}// output obj
	
	
	var get_seconds = function(){
		return output.timeout /1000;
	}// get_seconds()
	var set_seconds = function( newValue ){
		output.timeout =  (newValue!=null) ? newValue*1000 : null;
	}// set_seconds()
	output.addProperty("seconds", get_seconds, set_seconds);
	output.seconds = input.seconds;
	
	
	return output;
}// secretCode()